class Lexer:
    def __init__(self, data):
        self.data = data
        self.tokens = []
        self.keywords = [
            'penOut',
            'penGo',
            'penStop',
            'penIn'
        ]
    def tokenizer (self):
        for loc in self.data:
            tmp = []
            tid = ''

            for l in loc:
                if l == '"' and tid == '':
                    tid = "char"
                    tmp = []
                elif l == '"' and tid == 'char':
                    self.tokens.append({'id': tid, 'value': ''.join(tmp)})
                    tid = ''
                    tmp = []
                elif l == '\n':
                    if len(tmp) > 0:
                        self.tokens.append({'id': 'atom', 'value': ''.join(tmp)})
                        tmp = []
                elif l == ':':
                    self.tokens.append({'id': 'label', 'value': ''.join(tmp)})
                    tmp = []
                elif ''.join(tmp) in self.keywords:
                    self.tokens.append({'id': 'keyword', 'value': ''.join(tmp)})
                    tmp = []
                elif (l == ' ' or l == '\t') and tid != 'char':
                    continue
                elif l == '//' and tid == '':
                    tid = "comment"
                    tmp = []
                elif l == '//' and tid == 'comment':
                    self.tokens.append({'id': tid, 'value': ''.join(tmp)})
                    tid = ''
                    tmp = []
                else:
                    tmp.append(l) 
        return self.tokens